document.addEventListener("DOMContentLoaded", function() {
    // Smooth scrolling for CTA buttons
    document.querySelectorAll(".cta").forEach(button => {
        button.addEventListener("click", function() {
            const target = document.querySelector(".cta-section");
            if (target) {
                target.scrollIntoView({ behavior: "smooth" });
            }
        });
    });

    // Fade-in effect for sections on scroll
    const sections = document.querySelectorAll("section");
    const options = {
        threshold: 0.3,
        rootMargin: "0px"
    };

    const observer = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = 1;
                entry.target.style.transform = "translateY(0)";
                observer.unobserve(entry.target);
            }
        });
    }, options);

    sections.forEach(section => {
        section.style.opacity = 0;
        section.style.transform = "translateY(50px)";
        section.style.transition = "all 0.5s ease-out";
        observer.observe(section);
    });

    // Contact footer social media alert
    document.querySelector("footer").addEventListener("click", function() {
        alert("Follow us on social media for more updates!");
    });
});
